// $Id: CMidiSequence.cpp,v 1.3 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMidiSequence.hpp"
using Exponent::Midi::CMidiSequence;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiSequence, CCountedObject);

//	===========================================================================
CMidiSequence::CMidiSequence(const double sampleRate) 
			 : m_tempo(120.0)
			 , m_sampleRate(sampleRate)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiSequence);
}

//	===========================================================================
CMidiSequence::~CMidiSequence()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiSequence);
}

//	===========================================================================
void CMidiSequence::addTrack(CMidiTrack *track)
{
	m_tracks.addElement(track);
}

//	===========================================================================
void CMidiSequence::setSampleRate(const double sampleRate)
{
	if (m_sampleRate != sampleRate)
	{
		// Store the ratio between the two sequence sample rates
		const double ratio = sampleRate / m_sampleRate;

		// Offset all the events
		for (long i = 0; i < m_tracks.getArraySize(); i++)
		{
			CMidiTrack *track = m_tracks.elementAtIndex(i);

			if (track)
			{
				track->adjustDeltaTimeBy(ratio);
			}
		}

		// Store the new sample rate
		m_sampleRate = sampleRate;
	}
}

//	===========================================================================
void CMidiSequence::setTempo(const double tempo)
{
	m_tempo = tempo;
}

//	===========================================================================
void CMidiSequence::setTimeSignature(const CTimeSignature &timeSignature)
{
	m_timeSignature = timeSignature;
}

//	===========================================================================
const CMidiTrack *CMidiSequence::getTrackAtIndex(const long index) const
{ 
	return m_tracks.constElementAtIndex(index);
}

//	===========================================================================
CMidiTrack *CMidiSequence::getMutableTrackAtIndex(const long index)
{ 
	return m_tracks.elementAtIndex(index);
}

//	===========================================================================
void CMidiSequence::compact()
{
	m_tracks.reorder();
}

